"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthModule = void 0;
const common_1 = require("@nestjs/common");
const auth_controller_1 = require("./auth.controller");
const auth_service_1 = require("./auth.service");
const passport_1 = require("@nestjs/passport");
const jwt_1 = require("@nestjs/jwt");
const jwt_strategy_1 = require("./strategies/jwt.strategy");
const anonymous_strategy_1 = require("./strategies/anonymous.strategy");
const users_module_1 = require("../users/users.module");
const mail_module_1 = require("../mail/mail.module");
const is_exists_validator_1 = require("../utils/validators/is-exists.validator");
const is_not_exists_validator_1 = require("../utils/validators/is-not-exists.validator");
const session_module_1 = require("../session/session.module");
const jwt_refresh_strategy_1 = require("./strategies/jwt-refresh.strategy");
const super_admin_module_1 = require("../super-admin/super-admin.module");
let AuthModule = class AuthModule {
};
exports.AuthModule = AuthModule;
exports.AuthModule = AuthModule = __decorate([
    (0, common_1.Module)({
        imports: [
            users_module_1.UsersModule,
            session_module_1.SessionModule,
            passport_1.PassportModule,
            mail_module_1.MailModule,
            jwt_1.JwtModule.register({}),
            super_admin_module_1.SuperAdminModule
        ],
        controllers: [auth_controller_1.AuthController],
        providers: [
            is_exists_validator_1.IsExist,
            is_not_exists_validator_1.IsNotExist,
            auth_service_1.AuthService,
            jwt_strategy_1.JwtStrategy,
            jwt_refresh_strategy_1.JwtRefreshStrategy,
            anonymous_strategy_1.AnonymousStrategy,
        ],
        exports: [auth_service_1.AuthService],
    })
], AuthModule);
//# sourceMappingURL=auth.module.js.map