import { JwtService } from '@nestjs/jwt';
import { User } from '../users/entities/user.entity';
import { AuthEmailLoginDto } from './dto/auth-email-login.dto';
import { AuthUpdateDto } from './dto/auth-update.dto';
import { AuthRegisterLoginDto } from './dto/auth-register-login.dto';
import { UsersService } from 'src/users/users.service';
import { MailService } from 'src/mail/mail.service';
import { NullableType } from '../utils/types/nullable.type';
import { LoginResponseType } from './types/login-response.type';
import { ConfigService } from '@nestjs/config';
import { AllConfigType } from 'src/config/config.type';
import { SessionService } from 'src/session/session.service';
import { JwtRefreshPayloadType } from './strategies/types/jwt-refresh-payload.type';
import { JwtPayloadType } from './strategies/types/jwt-payload.type';
import { SuperAdminService } from '../super-admin/super-admin.service';
import { AuthSuperAdminEmailLoginDto } from './dto/auth-super-admin-email-login.dto';
export declare class AuthService {
    private jwtService;
    private usersService;
    private sessionService;
    private mailService;
    private configService;
    private superAdminService;
    constructor(jwtService: JwtService, usersService: UsersService, sessionService: SessionService, mailService: MailService, configService: ConfigService<AllConfigType>, superAdminService: SuperAdminService);
    validateLogin(loginDto: AuthEmailLoginDto): Promise<LoginResponseType>;
    validateSuperAdminLogin(loginDto: AuthSuperAdminEmailLoginDto): Promise<{
        token: string;
        tokenExpires: number;
        user: import("../super-admin/entities/super-admin.entity").SuperAdmin;
    }>;
    register(dto: AuthRegisterLoginDto): Promise<void>;
    confirmEmail(hash: string): Promise<void>;
    forgotPassword(email: string): Promise<void>;
    resetPassword(hash: string, password: string): Promise<void>;
    me(userJwtPayload: JwtPayloadType): Promise<NullableType<User>>;
    update(userJwtPayload: JwtPayloadType, userDto: AuthUpdateDto): Promise<NullableType<User>>;
    softDelete(user: User): Promise<void>;
    logout(data: Pick<JwtRefreshPayloadType, 'sessionId'>): Promise<void>;
    private getTokensData;
}
