"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BrandsController = void 0;
const common_1 = require("@nestjs/common");
const brands_service_1 = require("./brands.service");
const crud_1 = require("@dataui/crud");
const brand_entity_1 = require("./entities/brand.entity");
const swagger_1 = require("@nestjs/swagger");
const roles_decorator_1 = require("../auth/decorators/roles.decorator");
const role_enum_1 = require("../users/enums/role.enum");
const create_brand_dto_1 = require("./dto/create-brand.dto");
let BrandsController = class BrandsController {
    constructor(service) {
        this.service = service;
    }
    async createBrand(createBrandDto) {
        return await this.service.createBrand(createBrandDto);
    }
};
exports.BrandsController = BrandsController;
__decorate([
    (0, roles_decorator_1.Roles)(role_enum_1.RoleEnum.SUPER_ADMIN, role_enum_1.RoleEnum.ADMIN),
    (0, common_1.Post)(),
    (0, swagger_1.ApiOperation)({ summary: "Create brand", responses: { 201: { description: "Created" } } }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_brand_dto_1.CreateBrandDto]),
    __metadata("design:returntype", Promise)
], BrandsController.prototype, "createBrand", null);
exports.BrandsController = BrandsController = __decorate([
    (0, crud_1.Crud)({
        model: { type: brand_entity_1.Brand, },
        query: {
            join: {
                logo: { eager: true, },
            },
        },
        routes: {
            exclude: ['createManyBase', 'createOneBase', 'replaceOneBase'],
        },
    }),
    (0, swagger_1.ApiBearerAuth)(),
    (0, swagger_1.ApiTags)('brands'),
    (0, common_1.Controller)('brands'),
    __metadata("design:paramtypes", [brands_service_1.BrandsService])
], BrandsController);
//# sourceMappingURL=brands.controller.js.map