"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CategoryController = void 0;
const common_1 = require("@nestjs/common");
const category_service_1 = require("./category.service");
const crud_1 = require("@dataui/crud");
const category_entity_1 = require("./entities/category.entity");
const swagger_1 = require("@nestjs/swagger");
let CategoryController = class CategoryController {
    constructor(service) {
        this.service = service;
    }
    async getNestedCategories() {
        return await this.service.getNestedCategories();
    }
};
exports.CategoryController = CategoryController;
__decorate([
    (0, common_1.Get)('nested'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], CategoryController.prototype, "getNestedCategories", null);
exports.CategoryController = CategoryController = __decorate([
    (0, swagger_1.ApiBearerAuth)(),
    (0, swagger_1.ApiTags)('category'),
    (0, crud_1.Crud)({
        model: {
            type: category_entity_1.Category,
        },
        query: {
            join: { products: {}, subCategories: {}, icon: {}, parentCategory: {} },
        },
    }),
    (0, common_1.Controller)('category'),
    __metadata("design:paramtypes", [category_service_1.CategoryService])
], CategoryController);
//# sourceMappingURL=category.controller.js.map