"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CategoryService = void 0;
const common_1 = require("@nestjs/common");
const crud_typeorm_1 = require("@dataui/crud-typeorm");
const category_entity_1 = require("./entities/category.entity");
const typeorm_1 = require("@nestjs/typeorm");
let CategoryService = class CategoryService extends crud_typeorm_1.TypeOrmCrudService {
    constructor(repo) {
        super(repo);
    }
    async getNestedCategories() {
        const categories = await this.repo.find({ relations: { parentCategory: true, icon: true } });
        const nestedCategories = [];
        categories.forEach((category) => {
            if (!category.parentCategory) {
                nestedCategories.push(category);
            }
            else {
                const parent = categories.find((el) => { var _a; return el.id == ((_a = category.parentCategory) === null || _a === void 0 ? void 0 : _a.id); });
                if (parent) {
                    if (!parent.subCategories) {
                        parent.subCategories = [];
                    }
                    delete category.parentCategory;
                    parent.subCategories.push(category);
                }
            }
        });
        nestedCategories.forEach((category) => {
            return this.appendNestedLevel(category);
        });
        return nestedCategories;
    }
    appendNestedLevel(category, level = 0) {
        category.level = level;
        if (category.subCategories) {
            category.subCategories.forEach((subCategory) => {
                this.appendNestedLevel(subCategory, level + 1);
            });
        }
        return category;
    }
};
exports.CategoryService = CategoryService;
exports.CategoryService = CategoryService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(category_entity_1.Category)),
    __metadata("design:paramtypes", [Object])
], CategoryService);
//# sourceMappingURL=category.service.js.map