"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Category = void 0;
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const typeorm_1 = require("typeorm");
const product_entity_1 = require("../../products/entities/product.entity");
const file_entity_1 = require("../../files/entities/file.entity");
let Category = class Category {
};
exports.Category = Category;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", Number)
], Category.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    (0, swagger_1.ApiProperty)({ example: 'category name', description: 'The name of the category' }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], Category.prototype, "name", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    (0, swagger_1.ApiPropertyOptional)({ example: 'category description', description: 'The description of the category' }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], Category.prototype, "description", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: "icon_id", nullable: true }),
    (0, swagger_1.ApiPropertyOptional)({ description: "file id to upload" }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], Category.prototype, "iconId", void 0);
__decorate([
    (0, typeorm_1.OneToOne)(() => file_entity_1.FileEntity, (file) => file.category, { cascade: ['insert', 'update'] }),
    (0, typeorm_1.JoinColumn)({ name: "icon_id" }),
    __metadata("design:type", Object)
], Category.prototype, "icon", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => Category, (category) => category.parentCategory, { cascade: ['insert', 'update'] }),
    (0, typeorm_1.JoinColumn)({ name: 'sub_category_id' }),
    (0, swagger_1.ApiPropertyOptional)({ type: [Category], description: 'The sub categories of the category' }),
    __metadata("design:type", Array)
], Category.prototype, "subCategories", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => Category, (category) => category.subCategories, { cascade: true, onDelete: 'CASCADE', nullable: true }),
    (0, typeorm_1.JoinColumn)({ name: "parent_category_id" }),
    (0, swagger_1.ApiPropertyOptional)({ type: Category, description: 'The parent category of the category' }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsObject)(),
    __metadata("design:type", Object)
], Category.prototype, "parentCategory", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => product_entity_1.Product, (product) => product.category),
    __metadata("design:type", Array)
], Category.prototype, "products", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    __metadata("design:type", Date)
], Category.prototype, "createdAt", void 0);
__decorate([
    (0, typeorm_1.UpdateDateColumn)(),
    __metadata("design:type", Date)
], Category.prototype, "updated_at", void 0);
exports.Category = Category = __decorate([
    (0, typeorm_1.Entity)("categories"),
    (0, typeorm_1.Unique)(["name"])
], Category);
//# sourceMappingURL=category.entity.js.map