"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Filetype1701480437571 = void 0;
class Filetype1701480437571 {
    constructor() {
        this.name = 'Filetype1701480437571';
    }
    async up(queryRunner) {
        await queryRunner.query(`CREATE TABLE \`product\` (\`id\` int NOT NULL AUTO_INCREMENT, \`name\` varchar(255) NOT NULL, \`description\` varchar(255) NULL, \`price\` int NOT NULL, \`quantity\` int NOT NULL, \`discount\` int NOT NULL DEFAULT '0', \`status\` enum ('In Stock', 'Inactive', 'Sold Out', 'Deleted') NOT NULL DEFAULT 'In Stock', \`createdAt\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), \`updated_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6), \`category_id\` int NULL, \`created_by_id\` int NULL, PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`ALTER TABLE \`file\` ADD \`relationType\` enum ('Product') NOT NULL`);
        await queryRunner.query(`ALTER TABLE \`file\` ADD \`productId\` int NULL`);
        await queryRunner.query(`ALTER TABLE \`product\` ADD CONSTRAINT \`FK_0dce9bc93c2d2c399982d04bef1\` FOREIGN KEY (\`category_id\`) REFERENCES \`categories\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`product\` ADD CONSTRAINT \`FK_53345ffb00a286f308561c0d1c4\` FOREIGN KEY (\`created_by_id\`) REFERENCES \`user\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`file\` ADD CONSTRAINT \`FK_eae532e4ae79b4fc1ff7d1197ad\` FOREIGN KEY (\`productId\`) REFERENCES \`product\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
    }
    async down(queryRunner) {
        await queryRunner.query(`ALTER TABLE \`file\` DROP FOREIGN KEY \`FK_eae532e4ae79b4fc1ff7d1197ad\``);
        await queryRunner.query(`ALTER TABLE \`product\` DROP FOREIGN KEY \`FK_53345ffb00a286f308561c0d1c4\``);
        await queryRunner.query(`ALTER TABLE \`product\` DROP FOREIGN KEY \`FK_0dce9bc93c2d2c399982d04bef1\``);
        await queryRunner.query(`ALTER TABLE \`file\` DROP COLUMN \`productId\``);
        await queryRunner.query(`ALTER TABLE \`file\` DROP COLUMN \`relationType\``);
        await queryRunner.query(`DROP TABLE \`product\``);
    }
}
exports.Filetype1701480437571 = Filetype1701480437571;
//# sourceMappingURL=1701480437571-filetype.js.map