"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Category1703203325246 = void 0;
class Category1703203325246 {
    constructor() {
        this.name = 'Category1703203325246';
    }
    async up(queryRunner) {
        await queryRunner.query(`DROP INDEX \`IDX_492de04608d8a0f02ebf17c21f\` ON \`brand\``);
        await queryRunner.query(`ALTER TABLE \`file\` ADD \`createdAt\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6)`);
        await queryRunner.query(`ALTER TABLE \`file\` ADD \`updatedAt\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6)`);
        await queryRunner.query(`ALTER TABLE \`categories\` ADD \`icon_id\` varchar(36) NULL`);
        await queryRunner.query(`ALTER TABLE \`categories\` ADD UNIQUE INDEX \`IDX_1eff0de0a3d9e41ef91f9051cc\` (\`icon_id\`)`);
        await queryRunner.query(`ALTER TABLE \`file\` DROP COLUMN \`relationType\``);
        await queryRunner.query(`ALTER TABLE \`file\` ADD \`relationType\` varchar(255) NOT NULL`);
        await queryRunner.query(`CREATE UNIQUE INDEX \`REL_1eff0de0a3d9e41ef91f9051cc\` ON \`categories\` (\`icon_id\`)`);
        await queryRunner.query(`ALTER TABLE \`categories\` ADD CONSTRAINT \`FK_1eff0de0a3d9e41ef91f9051cc1\` FOREIGN KEY (\`icon_id\`) REFERENCES \`file\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
    }
    async down(queryRunner) {
        await queryRunner.query(`ALTER TABLE \`categories\` DROP FOREIGN KEY \`FK_1eff0de0a3d9e41ef91f9051cc1\``);
        await queryRunner.query(`DROP INDEX \`REL_1eff0de0a3d9e41ef91f9051cc\` ON \`categories\``);
        await queryRunner.query(`ALTER TABLE \`file\` DROP COLUMN \`relationType\``);
        await queryRunner.query(`ALTER TABLE \`file\` ADD \`relationType\` enum ('Product') NOT NULL`);
        await queryRunner.query(`ALTER TABLE \`categories\` DROP INDEX \`IDX_1eff0de0a3d9e41ef91f9051cc\``);
        await queryRunner.query(`ALTER TABLE \`categories\` DROP COLUMN \`icon_id\``);
        await queryRunner.query(`ALTER TABLE \`file\` DROP COLUMN \`updatedAt\``);
        await queryRunner.query(`ALTER TABLE \`file\` DROP COLUMN \`createdAt\``);
        await queryRunner.query(`CREATE UNIQUE INDEX \`IDX_492de04608d8a0f02ebf17c21f\` ON \`brand\` (\`logo_id\`)`);
    }
}
exports.Category1703203325246 = Category1703203325246;
//# sourceMappingURL=1703203325246-category.js.map