"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductSeedService = void 0;
const common_1 = require("@nestjs/common");
const product_entity_1 = require("../../../products/entities/product.entity");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
const enums_1 = require("../../../products/enums");
const faker_1 = require("@faker-js/faker");
let ProductSeedService = class ProductSeedService {
    constructor(productRepository) {
        this.productRepository = productRepository;
    }
    async run(categories, brands) {
        var _a, _b, _c;
        console.log("Seeding products ...");
        await this.productRepository.delete({});
        const products = [];
        const imageCategories = ["semiconductor", "powerconnector", "transistor",
            "microswitch", "DCMotor", "motherboard"];
        for (let i = 0; i < 100; i++) {
            const images = [];
            for (let j = 0; j < 3; j++) {
                images.push({
                    path: faker_1.faker.image.urlLoremFlickr({
                        category: imageCategories[Math.floor(Math.random() * imageCategories.length)]
                    })
                });
            }
            const product = {
                name: "product " + i,
                description: "product description " + i,
                price: Math.floor(Math.random() * 1000000),
                images,
                category: ((_c = (_b = (_a = categories[Math.floor(Math.random() * categories.length)]) === null || _a === void 0 ? void 0 : _a.subCategories) === null || _b === void 0 ? void 0 : _b[0]) === null || _c === void 0 ? void 0 : _c.id)
                    || categories[Math.floor(Math.random() * categories.length)],
                brand: { name: brands[Math.floor(Math.random() * brands.length)].name },
                quantity: Math.floor(Math.random() * 100),
                status: Object.values(enums_1.ProductStatus)[Math.floor(Math.random() * Object.values(enums_1.ProductStatus).length)],
                createdBy: { id: 1 },
            };
            products.push(product);
        }
        await this.productRepository.save(products);
        console.log("Seeding products completed");
    }
};
exports.ProductSeedService = ProductSeedService;
exports.ProductSeedService = ProductSeedService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(product_entity_1.Product)),
    __metadata("design:paramtypes", [typeorm_1.Repository])
], ProductSeedService);
//# sourceMappingURL=product-seed.service.js.map