"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@nestjs/core");
const seed_module_1 = require("./seed.module");
const status_seed_service_1 = require("./status/status-seed.service");
const user_seed_service_1 = require("./user/user-seed.service");
const super_admin_seed_service_1 = require("./super-admin/super-admin-seed.service");
const brand_seed_service_1 = require("./brand/brand-seed.service");
const category_seed_service_1 = require("./category/category-seed.service");
const product_seed_service_1 = require("./product/product-seed.service");
const slider_seed_service_1 = require("./slider/slider-seed.service");
const runSeed = async () => {
    const app = await core_1.NestFactory.create(seed_module_1.SeedModule);
    const promises = [];
    await app.get(status_seed_service_1.StatusSeedService).run();
    await app.get(super_admin_seed_service_1.SuperAdminSeedService).run();
    await app.get(user_seed_service_1.UserSeedService).run();
    const brands = await app.get(brand_seed_service_1.BrandSeedService).run();
    const categories = await app.get(category_seed_service_1.CategorySeedService).run();
    await app.get(product_seed_service_1.ProductSeedService).run(categories, brands);
    promises.push(Promise.resolve(app.get(slider_seed_service_1.SliderSeedService).run()));
    await Promise.all(promises);
    await app.close();
};
void runSeed();
//# sourceMappingURL=run-seed.js.map