import { ProductsService } from './products.service';
import { CrudController } from '@dataui/crud';
import { Product } from './entities/product.entity';
import { CreateProductDto } from './dto/create-product.dto';
import { customizedReqUser } from '../utils/types/request.type';
export declare class ProductsController implements CrudController<Product> {
    service: ProductsService;
    constructor(service: ProductsService);
    createProduct(createProductDto: CreateProductDto, req: customizedReqUser): Promise<{
        createdBy: number;
        name: string;
        description: string;
        price: number;
        quantity: number;
        discount: number;
        status: import("./enums").ProductStatus;
        categoryId: number;
        images: [];
    } & Product>;
}
