"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductsController = void 0;
const common_1 = require("@nestjs/common");
const products_service_1 = require("./products.service");
const swagger_1 = require("@nestjs/swagger");
const crud_1 = require("@dataui/crud");
const product_entity_1 = require("./entities/product.entity");
const roles_decorator_1 = require("../auth/decorators/roles.decorator");
const role_enum_1 = require("../users/enums/role.enum");
const passport_1 = require("@nestjs/passport");
const role_guard_1 = require("../auth/guards/role.guard");
const create_product_dto_1 = require("./dto/create-product.dto");
let ProductsController = class ProductsController {
    constructor(service) {
        this.service = service;
    }
    async createProduct(createProductDto, req) {
        return await this.service.createProduct(createProductDto, req);
    }
};
exports.ProductsController = ProductsController;
__decorate([
    (0, roles_decorator_1.Roles)(role_enum_1.RoleEnum.SUPER_ADMIN, role_enum_1.RoleEnum.ADMIN),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), role_guard_1.RoleGuard),
    (0, common_1.Post)(),
    (0, swagger_1.ApiOperation)({ summary: "Create product", responses: { 201: { description: "Created" } } }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_product_dto_1.CreateProductDto, Object]),
    __metadata("design:returntype", Promise)
], ProductsController.prototype, "createProduct", null);
exports.ProductsController = ProductsController = __decorate([
    (0, crud_1.Crud)({
        model: {
            type: product_entity_1.Product,
        },
        routes: {
            exclude: ['createManyBase', 'createOneBase', 'replaceOneBase'],
        },
        query: {
            join: { category: {}, subCategory: {}, images: {} },
        },
    }),
    (0, swagger_1.ApiBearerAuth)(),
    (0, swagger_1.ApiTags)('products'),
    (0, common_1.Controller)('products'),
    __metadata("design:paramtypes", [products_service_1.ProductsService])
], ProductsController);
//# sourceMappingURL=products.controller.js.map