import { TypeOrmCrudService } from '@dataui/crud-typeorm';
import { Product } from './entities/product.entity';
import { Repository } from 'typeorm';
import { CreateProductDto } from './dto/create-product.dto';
import { customizedReqUser } from '../utils/types/request.type';
export declare class ProductsService extends TypeOrmCrudService<Product> {
    private productRepository;
    constructor(productRepository: Repository<Product>);
    createProduct(createProductDto: CreateProductDto, req: customizedReqUser): Promise<{
        createdBy: number;
        name: string;
        description: string;
        price: number;
        quantity: number;
        discount: number;
        status: import("./enums").ProductStatus;
        categoryId: number;
        images: [];
    } & Product>;
}
