"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fileInterceptor = exports.FileFilterEnum = void 0;
const common_1 = require("@nestjs/common");
const platform_express_1 = require("@nestjs/platform-express");
const multer_1 = require("multer");
var FileFilterEnum;
(function (FileFilterEnum) {
    FileFilterEnum["IMAGE"] = "image";
    FileFilterEnum["VIDEO"] = "video";
    FileFilterEnum["AUDIO"] = "audio";
})(FileFilterEnum || (exports.FileFilterEnum = FileFilterEnum = {}));
function fileInterceptor(fieldName, folderName, filter) {
    return (0, platform_express_1.FileInterceptor)(fieldName, {
        storage: (0, multer_1.diskStorage)({
            destination: './public/' + folderName + '/',
            filename: (req, file, cb) => { cb(null, `${Date.now()}-${file.originalname}`); }
        }),
        fileFilter: (req, file, cb) => {
            if (filter === FileFilterEnum.IMAGE) {
                if (!file.originalname.match(/\.(jpg|jpeg|png|gif)$/)) {
                    return cb(new common_1.BadRequestException('Only image files are allowed!'), false);
                }
            }
            else if (filter === FileFilterEnum.VIDEO) {
                if (!file.originalname.match(/\.(mp4|mov|avi|wmv|flv|3gp)$/)) {
                    return cb(new common_1.BadRequestException('Only video files are allowed!'), false);
                }
            }
            else if (filter === FileFilterEnum.AUDIO) {
                if (!file.originalname.match(/\.(mp3|wav)$/)) {
                    return cb(new common_1.BadRequestException('Only audio files are allowed!'), false);
                }
            }
            cb(null, true);
        }
    });
}
exports.fileInterceptor = fileInterceptor;
//# sourceMappingURL=file.js.map