import { ApiProperty } from '@nestjs/swagger';
import { IsNotEmpty, Validate } from 'class-validator';
import { IsExist } from 'src/utils/validators/is-exists.validator';
import { Transform } from 'class-transformer';
import { lowerCaseTransformer } from 'src/utils/transformers/lower-case.transformer';

export class AuthSuperAdminEmailLoginDto {
    @ApiProperty({ example: 'abde-super@ecom.com' })
    @Transform(lowerCaseTransformer)
    @Validate(IsExist, ["super_admin"], {
        message: 'emailNotExists',
    })
    email: string;

    @ApiProperty({ example: 'abde123' })
    @IsNotEmpty()
    password: string;
}
