import { Body, Controller, Post, UploadedFile, UseInterceptors } from '@nestjs/common';
import { BrandsService } from './brands.service';
import { Crud, CrudController } from '@dataui/crud';
import { Brand } from './entities/brand.entity';
import { ApiBearerAuth, ApiConsumes, ApiOperation, ApiTags } from '@nestjs/swagger';
import { Roles } from '../auth/decorators/roles.decorator';
import { RoleEnum } from '../users/enums/role.enum';
import { FileInterceptor } from '@nestjs/platform-express';
import { diskStorage } from 'multer';
import { CreateBrandDto } from './dto/create-brand.dto';


@Crud({
  model: { type: Brand, },
  query: {
    join: {
      logo: { eager: true, },
    },
  },
  routes: {
    exclude: ['createManyBase', 'createOneBase', 'replaceOneBase'],
  },
})
@ApiBearerAuth()
@ApiTags('brands')
@Controller('brands')
export class BrandsController implements CrudController<Brand> {
  constructor(public readonly service: BrandsService) { }

  @Roles(RoleEnum.SUPER_ADMIN, RoleEnum.ADMIN)
  @Post()
  @ApiOperation({ summary: "Create brand", responses: { 201: { description: "Created" } } })
  async createBrand(@Body() createBrandDto: CreateBrandDto) {
    return await this.service.createBrand(createBrandDto);
  }
}
