import { Injectable } from '@nestjs/common';
import { TypeOrmCrudService } from '@dataui/crud-typeorm';
import { Brand } from './entities/brand.entity';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { CreateBrandDto } from './dto/create-brand.dto';


@Injectable()
export class BrandsService extends TypeOrmCrudService<Brand> {
  constructor(@InjectRepository(Brand) private brandRepository: Repository<Brand>) {
    super(brandRepository);
  }

  async createBrand(createBrandDto: CreateBrandDto) {
    return await this.brandRepository.save({ ...createBrandDto });
  }
}
