import { ApiProperty, ApiPropertyOptional } from "@nestjs/swagger";
import { IsOptional, IsString } from "class-validator";
import { Column, CreateDateColumn, Entity, JoinColumn, OneToMany, OneToOne, PrimaryGeneratedColumn, UpdateDateColumn } from "typeorm";
import { Product } from "../../products/entities/product.entity";
import { FileEntity } from "../../files/entities/file.entity";

@Entity("brand")
export class Brand {
    @PrimaryGeneratedColumn()
    id: number;

    @Column()
    @ApiProperty({ example: 'product name', description: 'The name of the product' })
    @IsString()
    name: string;


    @Column({ name: "logo_id", nullable: true })
    @ApiPropertyOptional({ description: 'The id of the logo' })
    @IsOptional()
    @IsString()
    logoId?: string;
    @OneToOne(() => FileEntity, (file) => file.brand, { cascade: ['insert', 'update'] })
    @JoinColumn({ name: "logo_id" })
    logo?: Partial<FileEntity>;

    @OneToMany(() => Product, (product) => product.brand)
    products?: Partial<Product>[] | number[];


    @CreateDateColumn()
    createdAt?: Date;

    @UpdateDateColumn()
    updated_at?: Date;
}
