import { Controller, Get, UseGuards } from '@nestjs/common';
import { CategoryService } from './category.service';
import { Crud, CrudController } from '@dataui/crud';
import { Category } from './entities/category.entity';
import { ApiBearerAuth, ApiTags } from '@nestjs/swagger';


@ApiBearerAuth()
@ApiTags('category')
@Crud({
  model: {
    type: Category,
  },
  query: {
    join: { products: {}, subCategories: {}, icon: {}, parentCategory: {} },
  },
})
@Controller('category')
export class CategoryController implements CrudController<Category> {
  constructor(public service: CategoryService) { }

  @Get('nested')
  async getNestedCategories() {
    return await this.service.getNestedCategories();
  }
}
