import { MigrationInterface, QueryRunner } from "typeorm";

export class Migrations1709247215133 implements MigrationInterface {
    name = 'Migrations1709247215133'

    public async up(queryRunner: QueryRunner): Promise<void> {
        await queryRunner.query(`ALTER TABLE \`brand\` DROP FOREIGN KEY \`FK_492de04608d8a0f02ebf17c21fa\``);
        await queryRunner.query(`DROP INDEX \`REL_492de04608d8a0f02ebf17c21f\` ON \`brand\``);
        await queryRunner.query(`ALTER TABLE \`brand\` DROP COLUMN \`logo_id\``);
        await queryRunner.query(`ALTER TABLE \`brand\` ADD \`logo_id\` varchar(255) NULL`);
        await queryRunner.query(`ALTER TABLE \`brand\` ADD UNIQUE INDEX \`IDX_492de04608d8a0f02ebf17c21f\` (\`logo_id\`)`);
        await queryRunner.query(`CREATE UNIQUE INDEX \`REL_492de04608d8a0f02ebf17c21f\` ON \`brand\` (\`logo_id\`)`);
        await queryRunner.query(`ALTER TABLE \`brand\` ADD CONSTRAINT \`FK_492de04608d8a0f02ebf17c21fa\` FOREIGN KEY (\`logo_id\`) REFERENCES \`file\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
    }

    public async down(queryRunner: QueryRunner): Promise<void> {
        await queryRunner.query(`ALTER TABLE \`brand\` DROP FOREIGN KEY \`FK_492de04608d8a0f02ebf17c21fa\``);
        await queryRunner.query(`DROP INDEX \`REL_492de04608d8a0f02ebf17c21f\` ON \`brand\``);
        await queryRunner.query(`ALTER TABLE \`brand\` DROP INDEX \`IDX_492de04608d8a0f02ebf17c21f\``);
        await queryRunner.query(`ALTER TABLE \`brand\` DROP COLUMN \`logo_id\``);
        await queryRunner.query(`ALTER TABLE \`brand\` ADD \`logo_id\` varchar(36) NULL`);
        await queryRunner.query(`CREATE UNIQUE INDEX \`REL_492de04608d8a0f02ebf17c21f\` ON \`brand\` (\`logo_id\`)`);
        await queryRunner.query(`ALTER TABLE \`brand\` ADD CONSTRAINT \`FK_492de04608d8a0f02ebf17c21fa\` FOREIGN KEY (\`logo_id\`) REFERENCES \`file\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
    }

}
