import { Injectable } from "@nestjs/common";
import { InjectRepository } from "@nestjs/typeorm";
import { Brand } from "../../../brands/entities/brand.entity";
import { Repository } from "typeorm";


@Injectable()
export class BrandSeedService {
    constructor(
        @InjectRepository(Brand) private repository: Repository<Brand>,
    ) { }

    async run() {
        console.log("Brand seed started...");
        let i = 1;
        //10 brands
        let brands: Partial<Brand>[] = [
            {
                id: i++, name: "Phoenix Contact",
                logo: { path: "https://plc-trade.com/pub/259813/norm-phoenix-contact.webp" }
            },
            {
                id: i++, name: "Siemens",
                logo: { path: "https://plc-trade.com/pub/1/norm-siemens.webp" }
            },
            {
                id: i++, name: "Schneider Electric",
                logo: { path: "https://plc-trade.com/pub/2/norm-schneider.webp" }
            },
            {
                id: i++, name: "ABB",
                logo: { path: "https://plc-trade.com/pub/930389/norm-abb.webp" }
            },
            {
                id: i++, name: "Omron",
                logo: { path: "https://plc-trade.com/pub/177952/norm-omron.webp" }
            },
            {
                id: i++, name: "Pepperl+Fuchs",
                logo: { path: "https://plc-trade.com/pub/421655/norm-pepperl-fuchs.webp" }
            },
            {
                id: i++, name: "Baumer",
                logo: { path: "https://plc-trade.com/pub/334159/norm-baumer.webp" }
            },
            {
                id: i++, name: "SICK",
                logo: { path: "https://plc-trade.com/pub/477550/norm-sick.webp" }
            },
            {
                id: i++, name: "Turck",
                logo: { path: "https://plc-trade.com/pub/506912/norm-turck.webp" }
            },
            {
                id: i++, name: "WEINTEK",
                logo: { path: "https://plc-trade.com/pub/253888/norm-weintek.webp" }
            }
        ];
        brands = await this.repository.save(brands);
        console.log("Brand seed completed.");
        return brands;
    }
}