import { Injectable } from "@nestjs/common";
import { Category } from "../../../category/entities/category.entity";
import { InjectRepository } from "@nestjs/typeorm";
import { Repository } from "typeorm";

@Injectable()
export class CategorySeedService {
    constructor(
        @InjectRepository(Category) private categoryRepository: Repository<Category>,
    ) { }

    async run() {
        await this.categoryRepository.delete({});
        let i = 0;
        let categories: Partial<Category>[] = [
            {
                id: ++i,
                name: "Power supply",
                icon: { path: "https://cdn-icons-png.flaticon.com/128/6637/6637988.png" },
                subCategories: [
                    {
                        name: "Industrial computer",
                    },
                    {
                        name: "Industrial monitor",
                    },
                    {
                        name: "Industrial panel PC",
                    },
                    {
                        name: "Industrial tablet",
                    },
                ]
            },
            {
                id: ++i,
                name: "Robot",
                icon: { path: "https://cdn-icons-png.flaticon.com/128/1404/1404716.png" },
                subCategories: [
                    {
                        name: "Industrial robot",
                    },
                    {
                        name: "Robot controller",
                    },
                    {
                        name: "Robot gripper",
                    },
                    {
                        name: "Robot tool",
                    },
                ]
            },
            {
                name: "Sensor",
                icon: { path: "https://cdn-icons-png.flaticon.com/128/2540/2540142.png" },
                subCategories: [
                    {
                        name: "Flow sensor",
                    },
                    {
                        name: "Force sensor",
                    },
                    {
                        name: "Level sensor",
                    },
                    {
                        name: "Light sensor",
                    },
                    {
                        name: "Motion sensor",
                    },
                    {
                        name: "Position sensor",
                    },
                    {
                        name: "Pressure sensor",
                    },
                    {
                        name: "Proximity sensor",
                    },
                    {
                        name: "Temperature sensor",
                    },
                    {
                        name: "Vibration sensor",
                    },
                    {
                        name: "Vision sensor",
                    },
                ]
            },
            {
                name: "PLC",
                icon: { path: "https://cdn-icons-png.flaticon.com/128/7082/7082602.png" },
                subCategories: [
                    {
                        name: "PLC controller",
                    },
                    {
                        name: "PLC expansion module",
                    },
                    {
                        name: "PLC power supply",
                    },
                    {
                        name: "PLC programming cable",
                    },
                    {
                        name: "PLC rack",
                    },
                    {
                        name: "PLC software",
                    },
                ]
            },
            {
                name: "HMI",
                icon: { path: "https://static.thenounproject.com/png/5664890-200.png" },
                subCategories: [
                    {
                        name: "HMI cable",
                    },
                    {
                        name: "HMI panel",
                    },
                    {
                        name: "HMI programming cable",
                    },
                    {
                        name: "HMI software",
                    },
                ]
            },
            {
                name: "Servo motor",
                icon: { path: "https://cdn-icons-png.flaticon.com/128/2061/2061899.png" },
                subCategories: [
                    {
                        name: "Servo drive",
                    },
                    {
                        name: "Servo motor cable",
                    },
                    {
                        name: "Servo motor encoder",
                    },
                    {
                        name: "Servo motor power cable",
                    },
                    {
                        name: "Servo motor software",
                    },
                ]
            },
        ];
        categories = await this.categoryRepository.save(categories);
        console.log("categories seed completed.");
        return categories;
    }

}