import { NestFactory } from '@nestjs/core';
import { SeedModule } from './seed.module';
import { StatusSeedService } from './status/status-seed.service';
import { UserSeedService } from './user/user-seed.service';
import { SuperAdminSeedService } from './super-admin/super-admin-seed.service';
import { BrandSeedService } from './brand/brand-seed.service';
import { CategorySeedService } from './category/category-seed.service';
import { ProductSeedService } from './product/product-seed.service';
import { SliderSeedService } from './slider/slider-seed.service';
import { Category } from '../../category/entities/category.entity';

const runSeed = async () => {
  const app = await NestFactory.create(SeedModule);

  const promises: any = [];
  // run
  await app.get(StatusSeedService).run();
  await app.get(SuperAdminSeedService).run();
  await app.get(UserSeedService).run();
  const brands = await app.get(BrandSeedService).run();
  const categories: Partial<Category>[] = await app.get(CategorySeedService).run();
  await app.get(ProductSeedService).run(categories, brands);
  promises.push(Promise.resolve(app.get(SliderSeedService).run()));

  await Promise.all(promises);

  await app.close();
};

void runSeed();
