import { Module } from '@nestjs/common';
import { ConfigModule } from '@nestjs/config';
import { TypeOrmModule } from '@nestjs/typeorm';
import appConfig from 'src/config/app.config';
import databaseConfig from 'src/database/config/database.config';
import { DataSource, DataSourceOptions } from 'typeorm';
import { TypeOrmConfigService } from '../typeorm-config.service';
import { StatusSeedModule } from './status/status-seed.module';
import { UserSeedModule } from './user/user-seed.module';
import { SuperAdminSeedModule } from './super-admin/super-admin-seed.module';
import { BrandSeedModule } from './brand/brand-seed.module';
import { CategorySeedModule } from './category/category-seed.module';
import { ProductSeedModule } from './product/product-seed.module';
import { SliderSeedModule } from './slider/slider-seed.module';

@Module({
  imports: [
    StatusSeedModule,
    UserSeedModule,
    SuperAdminSeedModule,
    BrandSeedModule,
    CategorySeedModule,
    ProductSeedModule,
    SliderSeedModule,
    ConfigModule.forRoot({
      isGlobal: true,
      load: [databaseConfig, appConfig],
      envFilePath: ['.env'],
    }),
    TypeOrmModule.forRootAsync({
      useClass: TypeOrmConfigService,
      dataSourceFactory: async (options: DataSourceOptions) => {
        return new DataSource(options).initialize();
      },
    }),
  ],
})
export class SeedModule { }
