import { Injectable } from "@nestjs/common";
import { InjectRepository } from "@nestjs/typeorm";
import { Slider } from "../../../slider/entities/slider.entity";
import { Repository } from "typeorm";
import { randomUUID } from "crypto";

@Injectable()
export class SliderSeedService {
    constructor(
        @InjectRepository(Slider) private sliderRepository: Repository<Slider>,
    ) { }

    async run() {
        console.log("Seeding sliders ...");
        await this.sliderRepository.delete({});
        const sliders: Partial<Slider>[] = [
            {
                id: randomUUID(),
                name: "Industrial computer",
                description: "Industrial computer",
                image: { path: "https://media.licdn.com/dms/image/C4D1BAQH92cG_YobUjw/company-background_10000/0/1593012526419/int_technics_cover?e=2147483647&v=beta&t=YHYMtx3RAMAsEzIKmtw09v8wLpJIt89mysQZLU77ByE" },
            },
            {
                id: randomUUID(),
                name: "Industrial monitor",
                description: "Industrial monitor",
                image: { path: "https://ce8dc832c.cloudimg.io/cdn/n/n@50a6370bd72d36e72510a166a6ef4a0ee1a50bb5/_cs_/2019/04/5ca59f4ec55d6/tme_edu_landing.jpg" },
            },
            {
                id: randomUUID(),
                name: "Industrial panel PC",
                description: "Industrial panel PC",
                image: { path: "https://wiautomation.anticipa.io/public/uploads/parcop/image/cms/08_09_2022_19_23_45_home_bg_image.webp" },
            },
            {
                id: randomUUID(),
                name: "Industrial tablet",
                description: "Industrial tablet",
                image: { path: "https://avsuwzdjuo.cloudimg.io/v7/_cs_/2020/04/5ea805c689191/2.jpg?w=971&h=373&org_if_sml=1&func=crop" },
            },
        ];
        await this.sliderRepository.save(sliders);
        console.log("Seeding sliders completed!");
    }
}