import { Injectable } from "@nestjs/common";
import { InjectRepository } from "@nestjs/typeorm";
import { SuperAdmin } from "../../../super-admin/entities/super-admin.entity";
import { Repository } from "typeorm";
import * as bcrypt from "bcrypt";

//define interface for super admin
export interface SuperAdminInterface {
    id: number;
    firstName: string;
    lastName: string;
    password: string;
    email: string;
    phoneNumber: string;
}
@Injectable()
export class SuperAdminSeedService {
    constructor(
        @InjectRepository(SuperAdmin)
        private superAdminRepository: Repository<SuperAdmin>,
    ) { }

    async run() {
        const email = "abde-super@ecom.com"
        const superAdmin = await this.superAdminRepository.findOneBy({ email });
        if (!superAdmin) {
            const hashedPass = await bcrypt.hash("abde123", 12);
            let superAdmin: SuperAdminInterface = new SuperAdmin();
            superAdmin = {
                id: 1,
                firstName: "super admin",
                lastName: "ecommerce",
                password: hashedPass,
                email,
                phoneNumber: "0637798895",
            };
            await this.superAdminRepository.save(superAdmin);
        } else {
            console.log("super admin already exists");
        }
    }
}