import {
  Column,
  Entity,
  PrimaryGeneratedColumn,
  AfterLoad,
  AfterInsert,
  ManyToOne,
  OneToOne,
  CreateDateColumn,
  UpdateDateColumn,
  JoinColumn,
} from 'typeorm';
import { ApiProperty } from '@nestjs/swagger';
import { Allow } from 'class-validator';
import { EntityHelper } from 'src/utils/entity-helper';
import appConfig from '../../config/app.config';
import { AppConfig } from 'src/config/app-config.type';
import { Product } from '../../products/entities/product.entity';
import { Brand } from '../../brands/entities/brand.entity';
import { Category } from '../../category/entities/category.entity';
import { Slider } from '../../slider/entities/slider.entity';

@Entity({ name: 'file' })
export class FileEntity extends EntityHelper {
  @ApiProperty({ example: 'cbcfa8b8-3a25-4adb-a9c6-e325f0d0f3ae' })
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Allow()
  @Column()
  path: string;


  @ManyToOne(() => Product, (product) => product.images)
  product: Product;

  @OneToOne(() => Brand, (brand) => brand.logo)
  brand: Brand;

  @OneToOne(() => Category, (category) => category.icon)
  category: Category;

  @OneToOne(() => Slider, (slider) => slider.image)
  slider: Slider;

  @AfterLoad()
  @AfterInsert()
  updatePath() {
    if (this.path.indexOf('/') === 0) {
      this.path = (appConfig() as AppConfig).backendDomain + this.path;
    }
  }

  @CreateDateColumn()
  createdAt?: Date;

  @UpdateDateColumn()
  updatedAt?: Date;
}
