import { ApiProperty, ApiPropertyOptional } from "@nestjs/swagger";
import { IsArray, IsEnum, IsNotEmpty, IsNumber, IsNumberString, IsOptional, IsString } from "class-validator";
import { ProductStatus } from "../enums";
import { Category } from "../../category/entities/category.entity";

export class CreateProductDto {
    @ApiProperty({ example: 'product name', description: 'The name of the product' })
    @IsString()
    name: string;

    @ApiProperty({ example: 'product description', description: 'The description of the product' })
    @IsString()
    description: string;

    @ApiProperty({ example: 1000, description: 'The price of the product' })
    @IsNumber()
    price: number;

    @ApiProperty({ example: 10, description: 'The quantity of the product' })
    @IsNumber()
    quantity: number;

    @ApiPropertyOptional({ example: 5, description: 'The discount of the product' })
    @IsOptional()
    @IsNumber()
    discount: number;

    @ApiProperty({ enum: ProductStatus, description: 'The status of the product' })
    @IsEnum(ProductStatus)
    status: ProductStatus;


    @ApiProperty({ example: 1, description: 'The category of the product' })
    @IsNumber()
    categoryId: number;

    //images (file entity)
    @ApiProperty({ example: { id: "c4bbf878-09d4-43d5-b417-78c94e6f2b32" }, description: 'The images of the product' })
    @IsArray()
    images: [];
}
