import { Body, Controller, Post, Req, UploadedFiles, UseGuards, UseInterceptors } from '@nestjs/common';
import { ProductsService } from './products.service';
import { ApiBearerAuth, ApiConsumes, ApiOperation, ApiTags } from '@nestjs/swagger';
import { Crud, CrudController } from '@dataui/crud';
import { Product } from './entities/product.entity';
import { Roles } from '../auth/decorators/roles.decorator';
import { RoleEnum } from '../users/enums/role.enum';
import { AuthGuard } from '@nestjs/passport';
import { RoleGuard } from '../auth/guards/role.guard';
import { CreateProductDto } from './dto/create-product.dto';
import { customizedReqUser } from '../utils/types/request.type';
import { FilesInterceptor } from '@nestjs/platform-express';
import { diskStorage } from 'multer';


@Crud({
  model: {
    type: Product,
  },
  routes: {
    exclude: ['createManyBase', 'createOneBase', 'replaceOneBase'],
  },
  query: {
    join: { category: {}, subCategory: {}, images: {} },
  },
})
@ApiBearerAuth()
@ApiTags('products')
@Controller('products')
export class ProductsController implements CrudController<Product> {
  constructor(public service: ProductsService) { }

  @Roles(RoleEnum.SUPER_ADMIN, RoleEnum.ADMIN)
  @UseGuards(AuthGuard('jwt'), RoleGuard)
  @Post()
  @ApiOperation({ summary: "Create product", responses: { 201: { description: "Created" } } })
  async createProduct(@Body() createProductDto: CreateProductDto, @Req() req: customizedReqUser) {
    return await this.service.createProduct(createProductDto, req);
  }
}
