import { TypeOrmCrudService } from '@dataui/crud-typeorm';
import { Injectable } from '@nestjs/common';
import { Product } from './entities/product.entity';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { CreateProductDto } from './dto/create-product.dto';
import { customizedReqUser } from '../utils/types/request.type';

@Injectable()
export class ProductsService extends TypeOrmCrudService<Product> {
  constructor(@InjectRepository(Product) private productRepository: Repository<Product>) {
    super(productRepository);
  }

  async createProduct(createProductDto: CreateProductDto, req: customizedReqUser) {
    return await this.productRepository.save({
      ...createProductDto, createdBy: req.user?.userId
    });
  }
}
