import { ApiProperty, ApiPropertyOptional } from "@nestjs/swagger";
import { IsObject, IsOptional, IsString, isObject } from "class-validator";

export class CreateSliderDto {
    @ApiProperty({ example: 'slider name', description: 'The name of the brand' })
    @IsString()
    name: string;

    @ApiPropertyOptional({ example: 'description', description: 'The description of the slider' })
    @IsOptional()
    @IsString()
    description: string;

    @ApiProperty({ example: "uuid", description: "file ids to upload" })
    @IsString()
    imageId: string;
}
