import { Column, CreateDateColumn, Entity, JoinColumn, OneToOne, PrimaryGeneratedColumn, UpdateDateColumn } from "typeorm";
import { FileEntity } from "../../files/entities/file.entity";
import { ApiPropertyOptional } from "@nestjs/swagger";
import { IsOptional, IsString } from "class-validator";

@Entity("slider")
export class Slider {
    @PrimaryGeneratedColumn("uuid")
    id: string;

    @Column()
    name: string;

    @Column()
    @ApiPropertyOptional({ example: 'description', description: 'The description of the slider' })
    @IsOptional()
    @IsString()
    description: string;

    @Column({ name: "image_id" })
    @ApiPropertyOptional({ example: "uuid", description: "file id to upload" })
    imageId: string;
    @OneToOne(() => FileEntity, (file) => file.slider, { cascade: ['insert', 'update'] })
    @JoinColumn({ name: "image_id" })
    image?: Partial<FileEntity>;


    @CreateDateColumn()
    createdAt?: Date;

    @UpdateDateColumn()
    updatedAt?: Date;
}
