import { Controller, Get, Post, Body, Patch, Param, Delete, UseGuards, UseInterceptors, UploadedFiles, Req, UploadedFile } from '@nestjs/common';
import { SliderService } from './slider.service';
import { Crud, CrudController } from '@dataui/crud';
import { Slider } from './entities/slider.entity';
import { ApiBearerAuth, ApiConsumes, ApiOperation, ApiTags } from '@nestjs/swagger';
import { Roles } from '../auth/decorators/roles.decorator';
import { RoleEnum } from '../users/enums/role.enum';
import { RoleGuard } from '../auth/guards/role.guard';
import { AuthGuard } from '@nestjs/passport';
import { FileFilterEnum, fileInterceptor } from '../utils/file';
import { CreateSliderDto } from './dto/create-slider.dto';
import { customizedReqUser } from '../utils/types/request.type';


@Crud({
  model: { type: Slider, },
  query: { join: { image: { eager: true, } }, },
  routes: {
    exclude: ['createManyBase', 'createOneBase', 'replaceOneBase'],
  },
})
@ApiBearerAuth()
@ApiTags('slider')
@Controller('slider')
export class SliderController implements CrudController<Slider> {
  constructor(public readonly service: SliderService) { }

  @Roles(RoleEnum.SUPER_ADMIN, RoleEnum.ADMIN)
  @UseGuards(AuthGuard('jwt'), RoleGuard)
  @Post()
  @ApiOperation({ summary: "Create product", responses: { 201: { description: "Created" } } })
  async createSlider(@Body() createSliderDto: CreateSliderDto) {
    return await this.service.createSlider(createSliderDto);
  }
}
