import { TypeOrmCrudService } from '@dataui/crud-typeorm';
import { Injectable } from '@nestjs/common';
import { Slider } from './entities/slider.entity';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { CreateSliderDto } from './dto/create-slider.dto';

@Injectable()
export class SliderService extends TypeOrmCrudService<Slider> {
  constructor(@InjectRepository(Slider) private sliderRepository: Repository<Slider>) {
    super(sliderRepository);
  }

  async createSlider(createSliderDto: CreateSliderDto) {
    return await this.sliderRepository.save({ ...createSliderDto });
  }

}
