import { BeforeInsert, BeforeUpdate, Column, CreateDateColumn, Entity, PrimaryGeneratedColumn } from "typeorm";
import bcrypt from 'bcrypt';


@Entity("super_admin")
export class SuperAdmin {
    @PrimaryGeneratedColumn()
    id: number;

    @Column({ name: "first_name" })
    firstName: string;

    @Column({ name: "last_name" })
    lastName: string;

    @Column()
    password: string;

    @Column()
    email: string;

    @Column()
    phoneNumber: string;

    @CreateDateColumn({ name: "created_at" })
    createdAt?: Date | null;


    @BeforeInsert()
    @BeforeUpdate()
    async setPassword() {
        const salt = await bcrypt.genSalt();
        this.password = await bcrypt.hash(this.password, salt);
    }
}
