var mongoose = require("mongoose");

var orderSchema = new mongoose.Schema({
    User: { type: mongoose.Schema.Types.ObjectId, ref: 'User', required: false },
    Product_qty: [
        { product: { type: mongoose.Schema.Types.ObjectId, ref: 'Product' }, qty: Number }
    ],
    client_infos: {
        fname: String,
        lname: String,
        email: String,
        phone: String,
        adress: String,
        adress2: String,
        city: String,
        zip: String,
        payment_method: String,
        billing_fname: String,
        billing_lname: String,
        billing_email: String,
        billing_phone: String,
        billing_adress: String,
        billing_adress2: String,
        billing_city: String,
        billing_zip: String
    },
    status: { type: String, default: "Pending" },
    shipping: Number,
    total: Number,
    TTC: Number
},
    { timestamps: true }
);


module.exports = mongoose.model("Order", orderSchema);
