$(".section-t").click(function (e) {
    $("#" + e.target.dataset.content).toggle("fast");
});

/************* category actions */
function edit(e, indx, cat_id) {
    e.classList.toggle("edit");
    e.classList.toggle("save");
    if (e.dataset.action == "edit") {
        $("#catname-" + indx).attr('contenteditable', true);
        e.dataset.action = "save";
    }
    else {
        fetch('/edit/category/' + cat_id, {
            method: 'PUT',
            headers: {
                'Content-type': 'application/json; charset=UTF-8'
            },
            body: JSON.stringify({ name: $("#catname-" + indx).text() })
        }).then(response => response.json()).then(function (res) {
            if (res.message == "success") {
                $("#catname-" + indx).attr('contenteditable', false);
                e.dataset.action = "edit";
            }
            else {
                alert("something went wrong");
            }
        })
    }
}

function delete_category(indx, cat_id, name) {
    var userChoice = confirm("are you sure you want to delete this category: " + name);
    if (!userChoice) return false;
    fetch('/delete/category/' + cat_id, {
        method: 'DELETE',
        headers: {
            'Content-type': 'application/json; charset=UTF-8'
        }
    }).then(response => response.json()).then(function (res) {
        if (res.message == "success") {
            location.reload();
        }
        else {
            alert("something went wrong: " + res.message);
        }
    });
}