let { cloudinary, uploads } = require("./cloudinary");
const fs = require('fs');


const createFile = async (file, folder) => {//file_path, folder_name
    const response = await uploads(file, folder);
    response.original_path = file;
    response.relative_path = file.split('public\\')[1];
    return response;
}


const deleteFile = async (public_id, path) => {
    try {
        await cloudinary.uploader.destroy(public_id, function (result) { console.log(result) });
        fs.unlinkSync(path);
    } catch (error) {
        console.log(error); return false;
    }
}


module.exports = { createFile, deleteFile };