const multer = require('multer');
var path = require('path');

var storageFun = (file_path) => {
    let storage = multer.diskStorage({
        destination: function (req, file, cb) {
            console.log(file_path);
            cb(null, file_path)
        },
        filename: function (req, file, cb) {
            cb(null, Date.now() + path.extname(file.originalname)) //Appending .extension
        }
    });
    let upload = multer({ storage: storage });
    return upload;
};

module.exports = { storageFun, multer };
