const Courier = require("@trycourier/courier");

const courier = Courier.CourierClient({ authorizationToken: process.env.COURIER_authorizationToken });


async function sendEmail(mailOptions) {

    try {

        const mailResponse = await courier.send({
            message: {
                content: {
                    title: mailOptions.subject,
                    body: mailOptions.html,
                },
                to: {
                    email: mailOptions.to
                },
                routing: {
                    method: "single",
                    channels: ["email"]
                },
                channels: {
                    email: {
                        providers: ["gmail"],
                        "override": {
                            "html": mailOptions.html
                        }
                    }
                },
            }
        });
        return mailResponse;
    } catch (err) { console.log(err); }

}

module.exports = sendEmail;